/*
 * plcnvm
 *
 * PLC NVM manager for slave PLC chips.
 * Paramconfig-related header file.
 *
 * Boots an external PLC chip loading a PLC firmware image through Ethernet
 *
 * Copyright (C) 2015, Broadcom Corporation. All Rights Reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef _PLCNVM_PARAMCONFIG_H_
#define _PLCNVM_PARAMCONFIG_H_


/************************************************
 *                 Typedefs
 ************************************************/

typedef enum
{
	PCONFIG_STATE_SET_MANUFACTURER_DEFAULTS,
	PCONFIG_STATE_OK,
	PCONFIG_STATE_UPDATE,
	PCONFIG_STATE_SET_BROADCOM_DEFAULTS,
}t_paramconfig_state;


 /***************************************************
 *             Public Function Prototypes
 ***************************************************/
#define PARAMCONFIG_HEADER_SIZE (0x20)

int NVMFwPktsParamconfigInit(void);
int NVMFwPktsParamconfigRead(int addr, int len, void *data);
int NVMFwPktsParamconfigWrite(int addr, int len, void *data);
void NVMFwPktsParamconfigFactoryReset(void);
void NVMFwPktsParamconfigStateSet(t_paramconfig_state pconfig_state);
t_paramconfig_state NVMFwPktsParamconfigStateGet(void );
int GetParamOffsetAndLengthByName(const char *filename, const char *param_name, int *offset, int *size);

#endif /* _PLCNVM_PARAMCONFIG_H_ */
